<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\BotCommands;
use common\models\Bots;

/**
 * BotCommandsSearch represents the model behind the search form of `common\models\BotCommands`.
 */
class BotCommandsSearch extends BotCommands
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'bot_id', 'status', 'admin', 'commandtype'], 'integer'],
            [['created_at', 'command', 'result', 'usercommand'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $r = explode('/',Yii::$app->request->url);
        //print_r($r);die();
        //$accessFilter = json_decode(Yii::$app->user->identity->groups);
        $query = BotCommands::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['created_at'=>SORT_DESC]],
        ]);

        $this->load($params);
        //$query->andFilterWhere(['group' => $accessFilter]);

        $query->andFilterWhere(['bot_id' => Bots::findByBotName(   explode('?', $r[2])[0])     ]);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'created_at' => $this->created_at,
            'bot_id' => $this->bot_id,
            'status' => $this->status,
            'admin' => $this->admin,
            'commandtype' => $this->commandtype,
        ]);

        $query->andFilterWhere(['ilike', 'command', $this->command])
            ->andFilterWhere(['ilike', 'result', $this->result])
            ->andFilterWhere(['ilike', 'usercommand', $this->usercommand]);

        return $dataProvider;
    }
}
